#version 330

uniform sampler2D normalMap;
uniform sampler2D diffuse;


in vec2 texCoord;
in vec3 n;
in vec3 t;
in vec3 ld;


out vec4 colorOut;

void main() {

	// normalize vectors and compute bitangent
	vec3 nn = normalize(n);
	vec3 tn = normalize(t);
	vec3 bt = normalize(cross(nn, tn));

	// get normal from the map data
	nn = normalize(vec3(texture(normalMap, texCoord) * 2.0 - 1.0));
	
	// compute tbn matrix
	mat3 tbn = mat3(tn, bt, nn);

    vec3 ldn = normalize(ld);
    ldn = transpose(tbn) * ldn;
	
	// transform normal to camera space and normalize
	//vec3 n = normalize(tbn * texNormal);

	float intensity = max(dot(nn,ldn), 0.0);

	vec4 color = texture(diffuse, texCoord);
	colorOut = 	(color * 2) * intensity ;


}

